;==================================================================

; Very Fast ZoomOut : 92+ screen (240x128)-> 89 screen (160x85)
; par Olivier Armand (ExtendeD)
;  <ola.e-ml@wanadoo.fr>
; Fvrier 2002

;==================================================================

; Utiliser les routines :
; -----------------------

; Crer un bloc mmoire de 256*5 octets.

; Gnrer la table avec GenerateZtable().
;			input :
;				a0 = adresse du bloc mmoire tampon cr

; Redimensionner un cran de 92+ avec FastZoom().
;			input :
;				a0 = src
;				a1 = dest
;				a2 = adresse du bloc mmoire tampon cr	

; Pour les deux routines, presque tous les registres sont dtruits.

;==================================================================

GenerateZTable:		;input : a0 = table_block address
	moveq   	#2,d7
\3Tables:
	move.w	  	#255,d0
 	moveq   	#0,d1 		;nbre -> 255
\1Table:
 	moveq   	#2,d2
	move.b  	#%11000000,d3
 	move.b  	d1,d4
 	cmp.b   	#1,d7
	bne.s     	\NoAdd
	add.b   	d4,d4
\NoAdd:
	moveq   	#0,d5
	tst.b   	d7
	bne.s     	\Do1Word  	;si pas table3
	move.b  	d4,d5
	and.b   	#%10000000,d5
	add.b   	d4,d4
	move.b  	#%01100000,d3 	;nouveau mask
	moveq   	#1,d2 		;un tour de moins
\Do1Word:
	move.b 		d4,d6
	and.b   	d3,d6
 	or.b    	d6,d5
 	add.b   	d4,d4
	lsr.b   	#2,d3
	dbra    	d2,\Do1Word
	cmp.b   	#2,d7
	bne.s     	\NotT1
	lsl.w   	#8,d5
\NotT1:
	cmp.b  		#1,d7
	bne.s     	\NotT2
	lsl.w   	#2,d5
\NotT2:
	tst.b  		d7
 	bne.s     	\NotT3
	lsr.b   	#3,d5
 	move.b  	d5,(a0)+
 	bra.s     	\T3Done
\NotT3:
	move.w  	d5,(a0)+
\T3Done:
	addq.b  	#1,d1 
	dbra    	d0,\1Table
	dbra    	d7,\3Tables
	rts
	
;==================================================================

ZCompress3Bytes		MACRO
 	move.b  	(a0)+,d0
	add.w   	d0,d0
	move.w  	0(a2,d0.w),d1
	moveq   	#0,d0
	move.b  	(a0)+,d0
	add.w   	d0,d0
	or.w    	0(a3,d0.w),d1
	moveq   	#0,d0
 	move.b  	(a0)+,d0
	or.b    	0(a4,d0.w),d1
	move.w  	d1,(a1)+
	ENDM
	
FastZoom:
;a2 = table_block address
;a0 = src
;a1 = dest

	moveq		#31,d3		;height/4 - 1
	lea    		512(a2),a3
 	lea     	512(a3),a4
	moveq   	#0,d0 		;la partie haute du word ne genera pas
\DoScreen:
	moveq		#2,d2
\Do3Lines:
 	ZCompress3Bytes
 	ZCompress3Bytes
 	ZCompress3Bytes
 	ZCompress3Bytes
 	ZCompress3Bytes
 	ZCompress3Bytes
 	ZCompress3Bytes
 	ZCompress3Bytes
 	ZCompress3Bytes
 	ZCompress3Bytes
	lea     	10(a1),a1
	dbra    	d2,\Do3Lines
	lea     	30(a0),a0
	dbra    	d3,\DoScreen
	rts
	
;==================================================================
